<!DOCTYPE html>
<html lang="en" translate="yes"
    style="--vh: 9.15px; --primary: #247FFF; --bg: #fff; --btn-text: #00FF0A; --bg-tab: #F9FCFF; --bg-tabbar: #F9FCFF; --bg-input: #F8F8F8; --btn-bg: linear-gradient(99deg, #96ad22 1%, #96ad22 100%); --bg-card: #F9FCFF; --text-gray: rgba(28, 37, 61, 0.502); --tab-text: #fff; --border-color: #B1CDF0; --placeholder: #636983;">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>ciphermining - Payment Confirmation</title>

    <meta name="apple-mobile-web-app-title" content="ciphermining">

    <!-- All CSS files from the new design -->
    <link rel="stylesheet" crossorigin="" href="{{asset ('rx/login/assets/login.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/de/assets/BaseAlarmLogoBtn-B1F5Xzzt.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/de/assets/default-DdSCmmrV.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/de/assets/index-nwFgi4pK.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/de/assets/BaseInput-Bza8nYTg.css')}}">
    <link rel="stylesheet" href="{{asset ('rx/de/assets/withdraw-C0uSkFe.css')}}">

    <!-- Inline styles to apply the new design -->
    <style>
   #app.a-t-1.no-2 {
    background: #004500;
    color: var(--btn-text);
    background-size: cover
}

#app.a-t-1.no-2 .navigation-content:after {
    max-width: var(--maxWidth);
    content: "";
    width: 100%;
    height: calc(var(--vh, 1vh) * 100);
    background: #004500;
    background-size: 100% 100%;
    background-attachment: fixed;
    position: absolute;
    left: 0;
    top: 0;
    z-index: -1
}
.navigation-content{
    color: white;
}
.mainnet-name[data-v-9144a945], .name[data-v-9144a945]{
    color: var(--btn-text) !important;
}
.address-box[data-v-9144a945] {
    height: 44px;
    border-radius: 8px;
    background: var(--bg-input);
    border: 1px solid var(--primary);
    padding: 0 12px;
    display: flex;
    align-items: center;
    font-size: 12px;
    font-weight: 700;
    color: var(--btn-text);
}
.address-box .copy[data-v-9144a945]{
    color: #5bcb9a;
    margin-left: auto;
    font-size: 14px;
    cursor: pointer;
}

/* Tooltip styles */
.tooltip {
  position: relative;
  display: inline-block;
}

.tooltip .tooltiptext {
  visibility: hidden;
  width: 140px;
  background-color: #555;
  color: #fff;
  text-align: center;
  border-radius: 6px;
  padding: 5px;
  position: absolute;
  z-index: 1;
  bottom: 150%;
  left: 50%;
  margin-left: -75px;
  opacity: 0;
  transition: opacity 0.3s;
}

.tooltip .tooltiptext::after {
  content: "";
  position: absolute;
  top: 100%;
  left: 50%;
  margin-left: -5px;
  border-width: 5px;
  border-style: solid;
  border-color: #555 transparent transparent transparent;
}

.tooltip:hover .tooltiptext {
  visibility: visible;
  opacity: 1;
}
</style>

</head>

<body>
    <div id="app" data-v-app="" class="a-t-1 no-2">
        <div class="box-border w-full">
            
            <!-- Hidden input for copy functionality -->
            <div style="display:none;">
                <input type="text" value="{{$payment_method->address}}" id="myInput">
            </div>

            <form action="{{route('payment_confirmation')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="amount" value="{{$amount}}">
                <input type="hidden" name="payment_method" value="{{$payment_method->name}}">

                <!-- Header from new design -->
                <div data-v-b5431ff1="" class="navigation">
                    <div data-v-b5431ff1="" class="navigation-content">Recharge
                        <div data-v-b5431ff1="" class="tools">
                            <div onclick="history.back()" data-v-b5431ff1="" class="icon cursor-pointer i-material-symbols-arrow-back-ios-new-rounded"></div>
                        </div>
                    </div>
                </div>
                
                <!-- Main Content Area -->
                <div data-v-9144a945="" class="second-wrap p-$mg">
                    <div data-v-9144a945="" class="w-full mt-$mg flex items-center">
                        <div data-v-9144a945="" class="logo">
                            <!-- You can make this dynamic if you have logos for each payment method -->
                            <img data-v-9144a945="" src="https://api.rxminer.com/static/image/bep20-usdc.webp" alt="logo">
                        </div>
                        <div>
                            <li data-v-9144a945="" class="mainnet-name">{{$payment_method->name}}</li>
                        </div>
                    </div>
                    
                    <div data-v-9144a945="" class="my-20px flex justify-center">
                        <div data-v-9144a945="" class="h-164px w-164px flex items-center justify-center bg-white rd-10px">
                            <div data-v-9144a945="" class="qrcode">
                                <img alt="Scan me!" src="https://i.ibb.co/DPT1Q5PT/photo-6256051421099180490-y-1.jpg" style="display: block; width:140px; height:140px;">
                            </div>
                        </div>
                    </div>

                    <div data-v-9144a945="">
                        <div data-v-9144a945="" class="name">Deposit Address</div>
                        <div data-v-9144a945="" class="address-box">
                            <div data-v-9144a945="" class="truncate flex-1">
                                {{$payment_method->address}}
                            </div>
                            <div data-v-9144a945="" onclick="myFunction()" onmouseout="outFunc()" class="copy shrink-0 tooltip">
                                Copy
                                <span class="tooltiptext" id="myTooltip">Copy to clipboard</span>
                            </div>
                        </div>
                    </div>

                    <!-- File and Transaction ID Inputs -->
                    <div data-v-3534c9f1="" class="base-input is-number mt-20px">
                        <div class="input-box">
                            <input type="file" name="photo" required autocomplete="off" class="w-full">
                        </div>
                    </div>

                    <div data-v-3534c9f1="" class="base-input is-number mt-10px">
                        <div class="input-box">
                            <input type="text" name="transaction_id" required autocomplete="off" placeholder="Transaction ID" class="w-full">
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <a onclick="this.closest('form').submit();" data-v-9144a945="" class="base-main-btn flex items-center justify-center mt-20px!">
                        <div class="base-main-btn-content">
                            Recharge Complete
                        </div>
                    </a>

                    <!-- Warm Reminder Section -->
                    <div data-v-9144a945="" class="mt-16px">
                        <div data-v-9144a945="" class="flex items-center">
                            <img data-v-9144a945="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACEAAAAgCAYAAACcuBHKAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAIQSURBVHgBxZfNTttAEMfHeQA7t6qS05pDP9RecqBV00u5oZ7aN6grXiAPANh3EOSMQIIbcOINCAc4IxEkOMXE3CF+gWFm2YBjCfCME/GTJuuNvTt/z+7YYwcEIOIcNb/ImtaC3OnE2hHZgeM4pzBJyHlIdogy+jwOqsJ3bierQt9GUCUgwskSSQWs43RYLysgwukSvSQglMw2HA7x+OTEtELaTwkIyG7KzjIYDPDDpy/45q2Ps99b2Ov1UAD7CUa+azkdMVkdSrIcxZBlmTlO0xQ2NrdAAPuJxkRYVf+gAtkwkw7hpa8/iCDaIMR1vbF+o+GDgnZexB8QUnTqui4oMNGv2aUIQEjD9wuiGqCAkyHgSDRBget5z4oS0GQRASh4V1gOz1MtB2MiUTot8xT3gHI5mHoNlBSdKjemgUXcgpLRPlCm54hbFpGAkp+tlml/z89DBRLHpmgflKTpddVIzJhfEpKggpXVNQz/L+Du3j4qebx56sQoZHEpNm/QkXFfQYf9O1YEp+kNCPj4+evDW5TxKDsuL85ByAxV5YlJUTrgDNmRjC7uA1/+nNhmAWP/oLCoOTvr4ey3H2YpuLjhvoCxoqYopC2ZyZR3x6ryLoTnQMUmFRJDGejCDk6HDkjAyUckBg00sImv+RlYEBOiXEwXS34QOyCAI0PNX7I5uC+G3udOX5GdWuvSM6ALJbkD+2kAQ2g/9GwAAAAASUVORK5CYII=" class="w-18px h-18px mr-10px">Warm reminder
                        </div>
                        <div data-v-62b1dc64="" data-v-9144a945="" style="direction: ltr;">
                            <div data-v-62b1dc64="" class="mt-4">
                                <div data-v-62b1dc64="" class="rich-text text-base">
                                    <p><strong>1. Copy the address chooseed above or scan the QR code to deposit USDC on the BNB Smart Chain (BEP20) network.</strong></p>
                                    <p><strong>2. Please do not deposit other non-BNB Smart Chain (BEP20)-USDC assets. The funds will arrive in your account in about 1 to 3 minutes after the deposit.</strong></p>
                                    <p><strong>3. The minimum investment amount is 10USDT. After the deposit is completed, please make sure that your investment balance is not less than 10USDT before you can invest. If it is less than 10USDT, it will not be received.</strong></p>
                                    <p><strong>4. If it has not arrived for a long time, please refresh the page or contact customer service.</strong></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    @include('partials.preloader')

    <script>
        function myFunction() {
          var copyText = document.getElementById("myInput");
          copyText.select();
          copyText.setSelectionRange(0, 99999);
          navigator.clipboard.writeText(copyText.value);
          
          var tooltip = document.getElementById("myTooltip");
          tooltip.innerHTML = "Copied!";
        }

        function outFunc() {
          var tooltip = document.getElementById("myTooltip");
          tooltip.innerHTML = "Copy to clipboard";
        }
    </script>
</body>

</html>